//
//  ToneGeneratorViewController.h
//  ToneGenerator
//
//  Created by Stanko Juzbašić 2014/01/19
//  Copyright 2014 Stanko Juzbašić. All rights reserved.
//  Ported and adapted from iOS code by Matt Gallagher on 2010/10/20.
//  Copyright 2010 Matt Gallagher. All rights reserved.
//
//  Permission is given to use this source code file, free of charge, in any
//  project, commercial or otherwise, entirely at your risk, with the condition
//  that any redistribution (in part or whole) of source code must retain
//  this copyright and permission notice. Attribution in compiled projects is
//  appreciated but not required.
//

#import <Cocoa/Cocoa.h>
#import <AudioUnit/AudioUnit.h>
#import <AudioToolbox/AudioToolbox.h>
#import <CoreMIDI/CoreMIDI.h>

#ifndef TWO_PI

#define TWO_PI 6.2831853071795864769252867665590057683943387987502116
#endif


//experimental
//#define ET 2.0439497289112
double logfreq (double, double, double);
double logval  (double, double, double);
//global audio variables
Float64 R; //read from hardware
double  A; //tuning
double  ET;//equal temperament factor 
//global MIDI variables
double  pitch;//read from MIDI
double  bend; //bend value
double  bendd;//bend depth
double  mmi;  //midi modulation index
double  nonl; //(0->1) from CC11 
BOOL    midi; //control flag set upon MIDI object creation
Byte    bmi;  //midi byte debug value
int     hold; //tracks how many notes have been held
Byte    n[16];//array of held notes
BOOL    holdit;
//callback prototype
OSStatus RenderTone(void *, 
                    AudioUnitRenderActionFlags 	*, 
                    const AudioTimeStamp 		*, 
                    UInt32 						, 
                    UInt32 						, 
                    AudioBufferList 			*);

//MIDI callback prototype
void     midiReadProc(const MIDIPacketList *,
                    void * , 
                    void * );

void    printPacketInfo(const MIDIPacket*);

//utilities prototypes
double Frequency (double);

double Pitch (double);

double TuningA(double);

double da(double);

//interface declaration
@interface ToneGeneratorViewController : NSViewController
{
	//NSTextField *frequencyLabel;
	NSButton *playButton;
	NSSlider *frequencySlider;	
    NSTextField *frequencyTextField;
    NSButton *sourceButton;
    NSButton *linlogButton;
    NSStepper *tuningStepper;
    NSSegmentedControl *segCtrlMult;
    NSButton *centerButton;
    NSButton *testButton;
    
@package
    AudioComponentInstance toneUnit;
    MIDIClientRef midiclient;
    MIDIPortRef   midiin;
    NSButton      *holdButton;
    
@public
	double      frequency;
    double      amplitude;
    double      previous_frequency;
    double      previous_amplitude;
	Float64     sampleRate;
    Float64     TWO_PI_NORM;
	double      phase;
    double      previous_phase_increment;
    int         state;
    NSInteger   midif;
    Boolean     logview;
    double      mult;
    
    AudioStreamBasicDescription streamFormat;
}

@property (nonatomic,retain) IBOutlet NSSlider *frequencySlider;

@property (nonatomic, retain) IBOutlet NSButton *playButton;

@property (nonatomic, retain) IBOutlet NSTextField *frequencyTextField;

@property (nonatomic, retain) IBOutlet NSButton *sourceButton;

@property (nonatomic, retain) IBOutlet NSButton *linlogButton;

@property (nonatomic, retain) IBOutlet NSStepper *tuningStepper;

@property (nonatomic, retain) IBOutlet NSSegmentedControl *segCtrlMult;

@property (nonatomic, retain) IBOutlet NSButton *centerButton;

@property (assign) IBOutlet NSButton *testButton;

@property (assign) IBOutlet NSButton *holdButton;


- (IBAction)sliderChanged:(NSSlider*)slider;

- (IBAction)togglePlay:(NSButton *)sender;

- (IBAction)sourceButtonClicked:(NSButton *)sender;

- (IBAction)linlogButtonClicked:(NSButton *)sender;

- (IBAction)tuningStepperClicked:(NSStepper *)sender;

- (IBAction)segCtrlMultClicked:(NSSegmentedControl *)sender;

- (IBAction)centerButtonClicked:(NSButton *)sender;

- (IBAction)testButtonClicked:(NSButton *)sender;

- (IBAction)holdButtonPressed:(NSButton *)sender;

- (void)midiIdFreqChanged:(NSNumber*)pitchNumber;

- (void)midiFreqChanged;

- (void)updateFrequencyControls;

- (void)stop;

- (void)createToneUnit;

- (void)createMIDI;

- (void)disposeMIDI;


@end

